# Load caret library
library(caret)
# Load a suitable dataset
data("Ionosphere", package = "mlbench")
# Split the data into training and testing sets
set.seed(123)
trainIndex <- createDataPartition(Ionosphere$Class, p = 0.8, list = FALSE)
train_data <- Ionosphere[trainIndex, ]
test_data <- Ionosphere[-trainIndex, ]

# Identify near-zero variance predictors in training data
nzv <- nearZeroVar(train_data, saveMetrics = TRUE)

# Remove zero or near-zero variance predictors from train and test data
train_data <- train_data[, !nzv$nzv]
test_data <- test_data[, colnames(test_data) %in% colnames(train_data)]

# Train the model
trained_model <- train(Class ~ ., data = train_data,
                       method = "lda",
                       trControl = trainControl(method = "cv", number = 5))

print(trained_model)

# Predict and evaluate
predictions <- predict(trained_model, newdata = test_data)
confusionMatrix(predictions, test_data$Class)